**B604: Test for any function with shell equals true**

Python possesses many mechanisms to invoke an external executable.
However, doing so may present a security issue if appropriate care is
not taken to sanitize any user provided or variable input.

This plugin test is part of a family of tests built to check for process
spawning and warn appropriately. Specifically, this plugin test
interrogates method calls for the presence of a keyword parameter shell
equalling true. It is related to detection of shell injection issues and
is intended to catch custom wrappers to vulnerable methods that may have
been created.

See also:

-   ../plugins/linux\_commands\_wildcard\_injection

-   ../plugins/subprocess\_popen\_with\_shell\_equals\_true

-   ../plugins/subprocess\_without\_shell\_equals\_true

-   ../plugins/start\_process\_with\_no\_shell

-   ../plugins/start\_process\_with\_a\_shell

-   ../plugins/start\_process\_with\_partial\_path

**Config Options:**

This plugin test shares a configuration with others in the same family,
namely shell\_injection. This configuration is divided up into three
sections, subprocess, shell and no\_shell. They each list Python calls
that spawn subprocesses, invoke commands within a shell, or invoke
commands without a shell (by replacing the calling process)
respectively.

Specifically, this plugin excludes those functions listed under the
subprocess section, these methods are tested in a separate specific test
plugin and this exclusion prevents duplicate issue reporting.

    shell_injection:
        # Start a process using the subprocess module, or one of its
        wrappers.
        subprocess: [subprocess.Popen, subprocess.call,
                     subprocess.check_call, subprocess.check_output
                     execute_with_timeout]

Example

:   

<!-- -->

    >> Issue: Function call with shell=True parameter identified, possible
    security issue.
       Severity: Medium   Confidence: High
       Location: ./examples/subprocess_shell.py:9
    8 pop('/bin/gcc --version', shell=True)
    9 Popen('/bin/gcc --version', shell=True)
    10

See also

-   <https://security.openstack.org/guidelines/dg_avoid-shell-true.html>

-   <https://security.openstack.org/guidelines/dg_use-subprocess-securely.html>
    \# noqa

New in version 0.9.0.
