**B606: Test for starting a process with no shell**

Python possesses many mechanisms to invoke an external executable.
However, doing so may present a security issue if appropriate care is
not taken to sanitize any user provided or variable input.

This plugin test is part of a family of tests built to check for process
spawning and warn appropriately. Specifically, this test looks for the
spawning of a subprocess in a way that doesn't use a shell. Although
this is generally safe, it maybe useful for penetration testing
workflows to track where external system calls are used. As such a LOW
severity message is generated.

See also:

-   ../plugins/linux\_commands\_wildcard\_injection

-   ../plugins/subprocess\_without\_shell\_equals\_true

-   ../plugins/start\_process\_with\_a\_shell

-   ../plugins/start\_process\_with\_partial\_path

-   ../plugins/subprocess\_popen\_with\_shell\_equals\_true

**Config Options:**

This plugin test shares a configuration with others in the same family,
namely shell\_injection. This configuration is divided up into three
sections, subprocess, shell and no\_shell. They each list Python calls
that spawn subprocesses, invoke commands within a shell, or invoke
commands without a shell (by replacing the calling process)
respectively.

This plugin specifically scans for methods listed in no\_shell section.

    shell_injection:
        no_shell:
            - os.execl
            - os.execle
            - os.execlp
            - os.execlpe
            - os.execv
            - os.execve
            - os.execvp
            - os.execvpe
            - os.spawnl
            - os.spawnle
            - os.spawnlp
            - os.spawnlpe
            - os.spawnv
            - os.spawnve
            - os.spawnvp
            - os.spawnvpe
            - os.startfile

Example

:   

<!-- -->

    >> Issue: [start_process_with_no_shell] Starting a process without a
       shell.
       Severity: Low   Confidence: Medium
       Location: examples/os-spawn.py:8
    7   os.spawnv(mode, path, args)
    8   os.spawnve(mode, path, args, env)
    9   os.spawnvp(mode, file, args)

See also

-   <https://security.openstack.org>

-   <https://docs.python.org/2/library/os.html#os.system>

-   <https://docs.python.org/2/library/subprocess.html#frequently-used-arguments>
    \# noqa

-   <https://security.openstack.org/guidelines/dg_use-subprocess-securely.html>

New in version 0.10.0.
