---
pageClass: rule-details
sidebarDepth: 0
title: vue/key-spacing
description: enforce consistent spacing between keys and values in object literal properties
---
# vue/key-spacing
> enforce consistent spacing between keys and values in object literal properties

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fixing-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [key-spacing] rule but it applies to the expressions in `<template>`.

## :books: Further reading

- [key-spacing]

[key-spacing]: https://eslint.org/docs/rules/key-spacing

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/key-spacing.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/key-spacing.js)
