## Use WORKDIR to switch to a directory.

### Problematic code:

```dockerfile
FROM busybox
RUN cd /usr/src/app && git clone git@github.com:lukasmartinelli/hadolint.git 
```

### Correct code:

```dockerfile
FROM busybox
RUN git clone git@github.com:lukasmartinelli/hadolint.git /usr/src/app
```

### Rationale:

Only use `cd` in a subshell. Most commands can work with absolute paths and it in most cases not necessary
to change directories. Docker provides the `WORKDIR` instruction if you really need to change the current
working directory.

### Exceptions:

When executed in a Subshell.