## Do not use `apk upgrade`

### Problematic code:

```dockerfile
FROM alpine:3.7
RUN apk update \
    && apk upgrade \
    && apk add foo=1.0 \
    && rm -rf /var/cache/apk/*
```

### Correct code:

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo=1.0
```
### Rationale:

You should avoid `RUN apk upgrade`, as many of the “essential” packages from the parent images won’t upgrade inside an [unprivileged container](https://docs.docker.com/engine/reference/run/#security-configuration). If a package contained in the parent image is out-of-date, you should contact its maintainers. If you know there’s a particular package, `foo`, that needs to be updated, use `apk --no-cache add foo` to update automatically.

> inspired by https://docs.docker.com/engine/userguide/eng-image/dockerfile_best-practices/#run