## Pin versions in gem install

### Problematic code:

```dockerfile
FROM ruby:2
RUN gem install bundler
```

### Correct code:

```dockerfile
FROM ruby:2
RUN gem install bundler:1.1
```
### Rationale:

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> Version pinning forces the build to retrieve a particular version regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.