Useless `echo`? Instead of `echo $(cmd)`, just use `cmd`
--------------------------------------------------------

### Problematic code:

```sh
echo "$(cat 1.txt)"
echo `< /dev/urandom tr -dc _A-Z-a-z-0-9 | head -c6`
```

### Correct code:

```sh
cat 1.txt # In bash, but faster and still sticks exactly one newline: printf '%s\n' "$(<1.txt)"
# The original `echo` sticks a newline; we want it too.
< /dev/urandom tr -dc _A-Z-a-z-0-9 | head -c6; echo
```

### Rationale

The command substitution `$(foo)` yields the result of command `foo` with trailing newlines erased, and when it is passed to `echo` it generally just gives the same result as `foo`.

### Exceptions

One may want to use command substitutions plus `echo` to make sure there is exactly one trailing newline. The special command substitution `$(<file)` in `bash` is also un-outline-able.

Anyway, echo is still not that reliable (see [[SC2039#echo-flags]]) and `printf` should be used instead.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2005)

