## Possible Misspelling: MYVARIABLE may not be assigned, but MY_VARIABLE is.

### Problematic code:

```sh
MY_VARIABLE="hello world"
echo "$MYVARIABLE"
```

### Correct code:

```sh
MY_VARIABLE="hello world"
echo "$MY_VARIABLE"
```

### Rationale:

ShellCheck has noticed that you reference a variable that is not assigned in the script, which has a name remarkably similar to one that is explicitly assigned. You should verify that the variable name is spelled correctly.

Note: This error only triggers for environment variables (all uppercase variables), and only when they have names similar to something assigned in the script. If the variable is script-local, it should by convention have a lowercase name, and will in that case be caught by [SC2154] whether or not it resembles another name.

### Exceptions:

If you've double checked and ensured that you did not intend to reference the specified variable, you can disable this message with a [[directive]]. The message will also not appear for guarded references like `${ENVVAR:-default}` or `${ENVVAR:?Unset error message here}`.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2153)

