## Some finds don't have a default path. Specify '.' explicitly.

### Problematic code:

```sh
find -type f
```

### Correct code:

```sh
find . -type f
```
### Rationale:

When not provided a search path, GNU and Busybox `find` will use a default path of `.`, the current directory.

On POSIX, macOS/OSX, FreeBSD, OpenBSD and NetBSD, it will instead result in an error.

Explicitly specifying a path works across all implementations, and is therefore preferred.

### Exceptions:

You will get a false positive if you concatenate a series of pre-path flags:

    find -XLE .

In such cases, please either use `find -X -L -E .` or [[ignore]] the message.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2185)

