## This pattern will never match the case statement's word. Double check them.

### Problematic code:

```sh
case "$var " in      # Trailing space
  value) echo "Match"
esac
```

### Correct code:

```sh
case "${var}" in     # No trailing space
  value) echo "Match"
esac
```
### Rationale:

ShellCheck has detected that one of the patterns in a `case` statement will never match. 

Often, this is due to mistakes in the case statement word that results in unintended literal characters. In the problematic code, there's a trailing space that will prevent the match from ever succeeding.

For more examples of when this could happen, see [SC2193](https://github.com/koalaman/shellcheck/wiki/SC2193) for the equivalent warning for `[[ .. ]]` statements.

Note that ShellCheck warns about individual patterns in a branch, and will flag `*.png` in this example even though the branch is not dead:

```
case "${img}.jpg" in
  *.png | *.jpg) echo "It's an image"
esac
```

### Exceptions:

None. If you encounter a bug and wish to [[ignore]] this warning, make sure the directive goes in front of the `case` and not the individual branch. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2195)

