## Remove superfluous `(..)` around condition.

### Problematic code:

```sh
if ([ "$x" -gt 0 ])
then true; fi
```

### Correct code:

```sh
if [ "$x" -gt 0 ]
then true; fi
```

### Rationale:

The shell syntax is `if cmd`, `elif cmd`, `while cmd` and `until cmd` without any parentheses. Instead, parentheses are an independent construct used to create subshells.

ShellCheck has noticed that you're wrapping `(..)` around one or more test commands. This is unnecessary, and the resulting fork adds quite a lot of overhead:

```
$ i=0; time while ( [ "$i" -lt 10000 ] ); do i=$((i+1)); done
real    0m6.998s
user    0m3.453s
sys     0m3.464s

$ i=0; time while [ "$i" -lt 10000 ]; do i=$((i+1)); done
real    0m0.055s
user    0m0.054s
sys     0m0.001s
```

Just delete the surrounding `(..)` since they serve no purpose and only slows the script down.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2233)

