
Assignments within sub-expressions are hard to spot and therefore make the code less readable. Ideally, sub-expressions should not have<br>side-effects.

## Noncompliant Code Example


    if (string.IsNullOrEmpty(result = str.Substring(index, length))) // Noncompliant
    {
      //...
    }


## Compliant Solution


    var result = str.Substring(index, length);
    if (string.IsNullOrEmpty(result))
    {
      //...
    }


## Exceptions

Assignments inside lambda and delegate expressions are allowed.

Furthermore, the following patterns are also accepted:


    var a = b = c = 10;



    while ((val = GetNewValue()) &gt; 0)
    {
    ...
    }



    private MyClass instance;
    public MyClass Instance
    {
      get
      {
        return instance ?? (instance = new MyClass());
      }
    }


## See

- [MITRE, CWE-481](http://cwe.mitre.org/data/definitions/481.html) - Assigning instead of Comparing
- [CERT, EXP45-C.](https://www.securecoding.cert.org/confluence/x/nYFtAg) - Do not perform assignments in selection statements
- [CERT, EXP51-J.](https://www.securecoding.cert.org/confluence/x/1gCTAw) - Do not perform assignments in conditional expressions<br>

