
`if` statements with conditions that are always false have the effect of making blocks of code non-functional. `if`<br>statements with conditions that are always true are completely redundant, and make the code less readable.

There are three possible causes for the presence of such code:

- An if statement was changed during debugging and that debug code has been committed.
- Some value was left unset.
- Some logic is not doing what the programmer thought it did.


In any of these cases, unconditional `if` statements should be removed.

## Noncompliant Code Example


    if (true)
    {
      DoSomething();
    }
    ...
    if (false)
    {
      DoSomethingElse();
    }


## Compliant Solution


    DoSomething();
    ...


## See

- [MITRE, CWE-489](http://cwe.mitre.org/data/definitions/489.html) - Leftover Debug Code
- [MITRE, CWE-570](http://cwe.mitre.org/data/definitions/570.html) - Expression is Always False
- [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571.html) - Expression is Always True


## Deprecated

This rule is deprecated; use {rule:csharpsquid:S2583} instead.
