
Calling `ToString()` on an object should always return a string. Returning `null` instead contravenes the method's implicit<br>contract.

## Noncompliant Code Example


    public override string ToString ()
    {
      if (this.collection.Count == 0)
      {
        return null; // Noncompliant
      }
      else
      {
        // ...
      }
    }


## Compliant Solution


    public override string ToString ()
    {
      if (this.collection.Count == 0)
      {
        return string.Empty;
      }
      else
      {
        // ...
      }
    }


## See

- [MITRE CWE-476](http://cwe.mitre.org/data/definitions/476.html) - NULL Pointer Dereference
- [CERT, EXP01-J.](https://www.securecoding.cert.org/confluence/x/ZwDOAQ) - Do not use a null in a case where an object is required<br>

