
A `for` loop with a counter that moves in the wrong direction is not an infinite loop. Because of wraparound, the loop will eventually<br>reach its stop condition, but in doing so, it will run many, many more times than anticipated, potentially causing unexpected behavior.

## Noncompliant Code Example


    public void DoSomething(string[] strings)
    {
      for (int i = 0; i &lt; strings.Length; i--)  // Noncompliant
      {
        string s = strings[i];  // IndexOutOfRangeException  when i reaches -1
        // do stuff
      }
    }


## Compliant Solution


    public void DoSomething(string[] strings)
    {
      for (int i = 0; i &lt; strings.Length; i++)
      {
        string s = strings[i];
        // do stuff
      }
    }


## See

- [CERT, MSC54-J.](https://www.securecoding.cert.org/confluence/x/zYEzAg) - Avoid inadvertent wrapping of loop counters

