
`public static` mutable fields of classes which are accessed directly should be protected to the degree possible. This can be done by<br>reducing the accessibility of the field or by changing the return type to an immutable type.

This rule raises issues for `public static` fields with a type inheriting/implementing `System.Array` or<br>`System.Collections.Generic.ICollection<T>`.

## Noncompliant Code Example


    public class A
    {
      public static string[] strings1 = {"first","second"};  // Noncompliant
      public static List&lt;String&gt; strings3 = new List&lt;String&gt;();  // Noncompliant
      // ...
    }


## Compliant Solution


    public class A
    {
      protected static string[] strings1 = {"first","second"};
      protected static List&lt;String&gt; strings3 = new List&lt;String&gt;();
      // ...
    }


## Exceptions

No issue is reported:

- If the type of the field inherits/implements one (at least) of the following types:
    - `System.Collections.ObjectModel.ReadOnlyCollection<T>`
    - `System.Collections.ObjectModel.ReadOnlyDictionary<TKey, TValue>`
    - `System.Collections.Immutable.IImmutableArray<T>`
    - `System.Collections.Immutable.IImmutableDictionary<TKey, TValue>`
    - `System.Collections.Immutable.IImmutableList<T>`
    - `System.Collections.Immutable.IImmutableSet<T>`
    - `System.Collections.Immutable.IImmutableStack<T>`
    - `System.Collections.Immutable.IImmutableQueue<T>`
- If the field is `readonly` and is initialized inline with an immutable type (i.e. inherits/implements one of the types in the<br>  previous list) or null.


## See

- [MITRE, CWE-582](http://cwe.mitre.org/data/definitions/582.html) - Array Declared Public, Final, and Static
- [MITRE, CWE-607](http://cwe.mitre.org/data/definitions/607.html) - Public Static Final Field References Mutable Object
- [CERT, OBJ01-J.](https://www.securecoding.cert.org/confluence/x/rwBc) - Limit accessibility of fields
- [CERT, OBJ13-J.](https://www.securecoding.cert.org/confluence/x/JQLEAw) - Ensure that references to mutable objects are not exposed<br>

