
In the absence of enclosing curly braces, the line immediately after a conditional is the one that is conditionally executed. By both convention<br>and good practice, such lines are indented. In the absence of both curly braces and indentation the intent of the original programmer is entirely<br>unclear and perhaps not actually what is executed. Additionally, such code is highly likely to be confusing to maintainers.

## Noncompliant Code Example


    if (condition)  // Noncompliant
    DoTheThing();
    
    DoTheOtherThing();
    SomethingElseEntirely();
    
    Foo();


## Compliant Solution


    if (condition)
      DoTheThing();
    
    DoTheOtherThing();
    SomethingElseEntirely();
    
    Foo();

