
The best way to determine the type of a generic method is by inference based on the type of argument that is passed to the method. This is not<br>possible when a parameter type is missing from the argument list.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void MyMethod&lt;T&gt;()  // Noncompliant
        {
        }
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void MyMethod&lt;T&gt;(T param)
        {
        }
      }
    }

