
Transparency attributes, `SecurityCriticalAttribute` and `SecuritySafeCriticalAttribute` are used to identify code that<br>performs security-critical operations. The second one indicates that it is safe to call this code from transparent, while the first one does not.<br>Since the transparency attributes of code elements with larger scope take precedence over transparency attributes of code elements that are contained<br>in the first element a class, for instance, with a `SecurityCriticalAttribute` can not contain a method with a<br>`SecuritySafeCriticalAttribute`.

This rule raises an issue when a member is marked with a `System.Security` security attribute that has a different transparency than the<br>security attribute of a container of the member.

## Noncompliant Code Example


    using System;
    using System.Security;
    
    namespace MyLibrary
    {
    
        [SecurityCritical]
        public class Foo
        {
            [SecuritySafeCritical] // Noncompliant
            public void Bar()
            {
            }
        }
    }


## Compliant Solution


    using System;
    using System.Security;
    
    namespace MyLibrary
    {
    
        [SecurityCritical]
        public class Foo
        {
            public void Bar()
            {
            }
        }
    }


## See

- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration

