# [Scala Play Server-Side Request Forgery (SSRF)](http://find-sec-bugs.github.io/bugs.htm#SCALA_PLAY_SSRF)

    Server-Side Request Forgery occur when a web server executes a request to a user supplied destination
    parameter that is not validated. Such vulnerabilities could allow an attacker to access internal services
    or to launch attacks from your web server.

    **Vulnerable Code:**

<pre>def doGet(value:String) = Action {
    WS.url(value).get().map { response =&gt;
        Ok(response.body)
    }
}</pre>

    **Solution/Countermeasures:**  

*   Don't accept request destinations from users
*   Accept a destination key, and use it to look up the target (legal) destination
*   White list URLs (if possible)
*   Validate that the beginning of the URL is part of a white list

**References**  

[CWE-918: Server-Side Request Forgery (SSRF)](https://cwe.mitre.org/data/definitions/918.html)  

[Understanding Server-Side Request Forgery](https://www.bishopfox.com/blog/2015/04/vulnerable-by-design-understanding-server-side-request-forgery/)