B110: Test for a pass in the except block
-----------------------------------------

Errors in Python code bases are typically communicated using
`Exceptions`{.docutils .literal .notranslate}. An exception object is
'raised' in the event of an error and can be 'caught' at a later point
in the program, typically some error handling or logging action will
then be performed.

However, it is possible to catch an exception and silently ignore it.
This is illustrated with the following example

This pattern is considered bad practice in general, but also represents
a potential security issue. A larger than normal volume of errors from a
service can indicate an attempt is being made to disrupt or interfere
with it. Thus errors should, at the very least, be logged.

There are rare situations where it is desirable to suppress errors, but
this is typically done with specific exception types, rather than the
base Exception class (or no type). To accommodate this, the test may be
configured to ignore 'try, except, pass' where the exception is typed.
For example, the following would not generate a warning if the
configuration option `checked_typed_exception`{.docutils .literal
.notranslate} is set to False:

**Config Options:**
