
*Since CodeNarc 0.14*

This rule reports violations of the Enterprise JavaBeans specification by using the java.io package to access files or the file system.

The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that
the bean will be portable and behave consistently in any EJB container [1].

In this case, the program violates the following EJB guideline: "An enterprise bean must not use the java.io package to attempt to access files and directories in the file system."

A requirement that the specification justifies in the following way: "The file system APIs are not well-suited for business components to access data. Business components should use a resource manager API, such as JDBC, to store data."

REFERENCES
  - [1] Standards Mapping - Common Weakness Enumeration - (CWE) CWE ID 576
  - [2] The Enterprise JavaBeans 2.1 Specification Sun Microsystems

By default, this rule is not applied to tests and test cases.

Example of violations:

```
    FileSystem.getFileSystem()          // any method on FileSystem
    FileSystem.fileSystem.delete(aFile) // property access of FileSystem

    // shouldn't create files
    new File(name)
    new File(name, parent)

    // don't create file readers
    new FileReader(name)

    // don't create file output streams
    new FileOutputStream(name)
    new FileOutputStream(name, true)

    // don't create random access file
    new RandomAccessFile(name, parent)
```

