package docs.tests

//#Patterns: Custom_Scala_SprayUntrustedContentTypeHeader
import akka.actor.{ Actor, ActorSystem, Props }
import akka.io.IO
import akka.pattern.ask
import akka.util.Timeout

import spray.http.HttpHeaders.`Content-Type`
import spray.can.Http
import spray.http.HttpHeaders.Host
import spray.routing._
import spray.http._
import org.json4s._
import org.json4s.jackson.Serialization.formats
import spray.httpx.Json4sJacksonSupport

import scala.concurrent.duration._

import scala.concurrent.duration._

object WebServer extends App {

  implicit val system = ActorSystem("spray-example")

  val service = system.actorOf(Props[DemoServiceActor], "demo-service")

  implicit val timeout = Timeout(5.seconds)

  IO(Http) ? Http.Bind(service, interface = "localhost", port = 8080)
}

class DemoServiceActor extends Actor with DemoService {
  def actorRefFactory = context
  def receive = runRoute(route)
}

object Support extends Json4sJacksonSupport {
  implicit val json4sJacksonFormats = formats(NoTypeHints)
}

trait DemoService extends HttpService {
  import Support._

  val route =
    headerValue {
  //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
      case ct: `Content-Type` => Some(ct)
      case _ => None
    } ( h => complete(h) ) ~
      headerValue {
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
        case `Content-Type`(ct) => Some(ct)
        case _ => None
      } ( ct => complete(ct) ) ~
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
      headerValueByType[HttpHeaders.`Content-Type`]() { ct =>
        complete(ct.contentType)
      } ~
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
      headerValueByName("Content-Type") { ct =>
        complete(ct)
      } ~
      headerValuePF({
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
        case ct: `Content-Type` => ct
      })( ct => complete(ct)  ) ~
      optionalHeaderValue{
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
        case ct: `Content-Type`=> Some(ct.contentType)
        case x => None
      }( ct => complete(ct) ) ~
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
      optionalHeaderValueByName("Content-Type") { ct =>
        complete(ct)
      } ~
      optionalHeaderValuePF({
      //#Warn: Custom_Scala_SprayUntrustedContentTypeHeader
        case h: `Content-Type`=> h
      })( complete(_)  )

}