## Shells are space sensitive. Use '< <(cmd)', not '<<(cmd)'.

### Problematic code:

```sh
while IFS= read -r line
do
  printf "%q\n" "$line"
done <<(curl -s http://example.com)
```

### Correct code:

```sh
while IFS= read -r line
do
  printf "%q\n" "$line"
done <  <(curl -s http://example.com)
```

### Rationale:

You are using `<<(` which is an invalid construct.

You probably meant to redirect `<` from process substitution `<(..)` instead. To do this, a space is needed between the `<` and `<(..)`, i.e. `< <(cmd)`.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1038)

