## Remove indentation before end token (or use `<<-` and indent with tabs).

### Problematic code:

```sh
for f in *.png
do
  cat << EOF
     <img src="$f" /><br/>
  EOF
done > index.html
```

### Correct code:

```sh
for f in *.png
do
  cat << EOF
     <img src="$f" /><br/>
EOF
done > index.html
```
### Rationale:

The here document delimiter will not be recognized if it is indented.

You can fix it in one of two ways:

1. Simply remove the indentation, even though this may break formatting.
2. Use `<<-` instead of `<<`, and indent the script with tabs only (spaces will not be recognized).

Removing the indentation is preferred, since the script won't suddenly break if it's reformatted, copy-pasted, or saved with a different editor.

### Exceptions:

If the line was supposed to be a literal part of the here document, consider choosing a less ambiguous token.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1039)

