## Use #!, not just !, for the shebang.

### Problematic code:

```sh
!/bin/sh
echo "Hello"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello"
```

### Rationale:

You appear to be specifying an interpreter in a shebang, but it's missing the hash part. The shebang must always start with `#!`. 

Even the name "shebang" itself comes from "hash" (`#`) + "bang" (`!`). 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1104)

