## Use `elif` to start another branch.

### Problematic code:

```sh
if false
then
  echo "hi"
elseif true
then
  echo "ho"
fi
```

### Correct code:

```sh
if false
then
  echo "hi"
elif true
then
  echo "ho"
fi
```
### Rationale:

ShellCheck noticed that you appear to be using `elseif` or `elsif` as a keyword. This is not valid.

`sh` instead uses `elif` as its alternative branch keyword.

### Exceptions:

If you have made your own function called `elseif` and intend to call it, you can ignore this message.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1131)

