## This `&` terminates the command. Escape it or add space after `&` to silence.

### Problematic code:

```sh
curl https://www.google.com/search?q=cats&tbm=isch
```

### Correct code:

```sh
curl "https://www.google.com/search?q=cats&tbm=isch"
```
### Rationale:

An unescaped and unquoted `&` terminates the command, but here it's used in the middle of what would otherwise be a shell word. This most commonly happens when copying a URL with query string parameters without escaping the `&`. 

Either quote or escape the `&` if you wanted it as a literal ampersand, or add a space after it to make it easier to see where the previous command stopped.

### Exceptions:

If you do want to background one command and run another, e.g. `sleep 10&wait`, just add a space or linefeed after the `&` to make this more obvious: `sleep 10& wait`

This does not change the meaning of the script, it just makes it clear to ShellCheck (and other humans) that the `&` isn't supposed to be a part of the shell world.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1132)

