# tr replaces sets of chars, not words (mentioned due to duplicates).

### Problematic code:

```sh
echo 'hello world' | tr 'hello' 'goodbye'
```

### Correct code:

```sh
echo 'hello world' | sed -e 's/hello/goodbye/g'
```

### Rationale:

`tr` is for `tr`ansliteration, turning some characters into other characters. It doesn't match strings or words, only individual characters.

In this case, it transliterates h->g, e->o, l->d, o->y, resulting in the string "goddb wbrdd" instead of "goodbye world".

The solution is to use a tool that does string search and replace, such as sed.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2020)

