# Don't use variables in the printf format string. Use printf "..%s.." "$foo".

### Problematic code:

```sh
printf "Hello, $NAME\n"
```

### Correct code:

```sh
printf "Hello, %s\n" "$NAME"
```

### Rationale:

`printf` interprets escape sequences and format specifiers in the format string. If variables are included, any escape sequences or format specifiers in the data will be interpreted too, when you most likely wanted to treat it as data. Example:

```sh
coverage='96%'
printf "Unit test coverage: %s\n" "$coverage"
printf "Unit test coverage: $coverage\n"
```

The first printf writes `Unit test coverage: 96%`.

The second writes ``bash: printf: `\': invalid format character``

### Exceptions

Sometimes you may actually want to interpret data as a format string, like in:

```sh
octToAscii() { printf "\\$1"; }
octToAscii 130
```

In Bash, Ksh and BusyBox, there's a `%b` format specifier that expands escape sequences without interpreting other format specifiers: `printf '%b' "\\$1"`. In POSIX, you can instead [[ignore]] this warning.

Other times, you might have a pattern in a variable:

```sh
filepattern="file-%d.jpg"
printf -v filename "$filepattern" "$number"
```

This has no good rewrite. Please [[ignore]] the warning with a [[directive]].
[Source](https://github.com/koalaman/shellcheck/wiki/SC2059)

