## `[ .. ]` can't match globs. Use `[[ .. ]]` or grep.

### Problematic code:

```sh
if [ $var == *[^0-9]* ]
then
  echo "$var is not numeric"
fi 
```

### Correct code:

```sh
if [[ $var == *[^0-9]* ]]
then
  echo "$var is not numeric"
fi 
```
### Rationale:

`[ .. ]` aka `test` can not match against globs. 

In bash/ksh, you can instead use `[[ .. ]]` which supports this behavior.

In sh, you can rewrite to use `grep`. 

### Exceptions:

None. If you are not trying to match a glob, quote the argument (e.g. `[ $var == '*' ]` to match literal asterisk. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2081)

