# To assign a variable, use just 'var=value', no 'set ..'.

### Problematic code:

```sh
set var=42
set var 42
```

### Correct code:

```sh
var=42
```

### Rationale:

`set` is not used to set or assign variables in Bourne shells. It's used to set shell options and positional parameters.

To assign variables, use `var=value` with no `set` or other qualifiers.

### Exceptions

If you actually do want to set positional parameters, simply quoting them or using `--` will make shellcheck stop warning, e.g. `set -- var1 var2` or `set "foo=bar"`.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2121)

