## 'local' is only valid in functions.

### Problematic code:

```sh
local foo=bar
echo "$foo"
```

### Correct code:

```sh
foo=bar
echo "$foo"
```
### Rationale:

In Bash, `local` can only be used in functions. In other contexts, it's an error.

### Exceptions:

It's possible to source files containing `local` from a function context but not from any other context. This is not good practice, but in these cases you can [[ignore]] this error.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2168)

