## Elements in associative arrays need index, e.g. array=( [index]=value ) .

### Problematic code:

```sh
declare -A foo
foo=( myvalue )
```

### Correct code:

```sh
declare -A foo
foo=( [key]=myvalue )
```
### Rationale:

You appear to be initializing or appending an array element to an associative array without giving it an index. In an indexed array, elements will be auto-indexed by incremented characters. In associative arrays, the index must be given explicitly.

This could happen because of invalid spaces or otherwise malformed index assignment, such as `array=( [key] = value )`. This should instead be `array=( [key]=value )`.

### Exceptions:

ShellCheck may be confused when a variable name is reused in different contexts. If shellcheck mistakenly believes the array is associated, please [[ignore]] this error. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2190)

