## This is a file redirection. Was it supposed to be a comparison or fd operation?

### Problematic code:

```sh
if x > 5; then echo "true"; fi
```
or
```sh
foo > /dev/null 2>1
```

### Correct code:

```sh
if (( x > 5 )); then echo "true"; fi
```
or
```sh
foo > /dev/null 2>&1
```
### Rationale:

You are redirecting to or from a filename that is an integer. For example, `ls > file` where `file` happens to be `3`.

This is not likely to be intentional. The most common causes are:

1. Trying to compare two numbers, as in `x > 5`. This should instead be `[ "$x" -gt 5 ]` or `(( x > 5 ))`.
1. Trying similarly to compare command output, as in `grep -c foo file > 100` instead of `[ "$(grep -c foo file)" -gt 100 ]`
1. Malformed FD operations, such as writing `1>2` instead of `1>&2`.

### Exceptions:

None. If you do want to create a file named `4`, you can quote it to silence shellcheck and make it more clear to humans that it's not supposed to be taken numerically.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2210)

