## This flag is used as a command name. Bad line break or missing `[ .. ]`?

### Problematic code:

```sh
if -e .bashrc
then
  echo ".bashrc already exists"
fi
```

or

```sh
find . -name '*.mkv'
       -exec mplayer {} \;
```

### Correct code:

```sh
if [ -e .bashrc ]
then
  echo ".bashrc already exists"
fi
```

or

```sh
find . -name '*.mkv' \
       -exec mplayer {} \;
```
### Rationale:

You are using a name that starts with a dash as a command name. This is almost always a bug.

There are two typical ways in which this happens:

* Missing `[ .. ]` or `[[ .. ]]` around a test expression, like in the first example example. 
* An invalid line break that splits a command in two, like in the second example.

### Exceptions:

If you actually have a command that starts with a dash -- which you should really reconsider -- you can quote the name (or at least the leading dash). This makes no difference to the shell, but makes it clear to ShellCheck and humans that this is not intended as a flag.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2215)

