## This ln has no destination. Check the arguments, or specify '.' explicitly.

### Problematic code:

```sh
ln "$file $dir"
```

or

```sh
ln /foo/bar/baz
```

### Correct code:

```sh
ln "$file" "$dir"
```

or

```sh
ln /foo/bar/baz .
```
### Rationale:

ShellCheck found a `ln` command with a single parameter. This may be because the source and destination was accidentally merged into a single argument, because the line was broken in an invalid way, or because you're using a non-standard invocation of `ln` that defaults to linking the argument into the current directory.

If you wanted to specify both source and destination, fix the `ln` statement.

If you wanted to link a file into the current directory, prefer using the more explicit and POSIX standard invocation `ln /your/file .` 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2226)

