## The dot command does not support arguments in sh/dash. Set them as variables.

### Problematic code:

```sh
#!/bin/sh
. include/myscript example.com 80
```

### Correct code:

```sh
#!/bin/sh
host=example.com port=80 . include/myscript 
```
### Rationale:

In Bash and Ksh, you can use `. myscript arg1 arg2..` to set `$1` and `$2` in the sourced script.

This is not the case in Dash, where any additional arguments are ignored, or in POSIX sh where the behavior is unspecified.

Instead, assign arguments to variables and rewrite the sourced script to read from them.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2240)

