## Use -R to recurse, or explicitly a-r to remove read permissions.

### Problematic code:

```sh
chmod -r 0700 dir
chmod -r file
```

### Correct code:

```sh
chmod -R 0700 dir
chmod a-r file
```

### Rationale:

Many tools use `-r` for recursive operation, but in `chmod` this removes read permissions.

If you wanted to change permissions recursively, change the flag to `-R`. If you wanted to remove read permissions, consider using `a-r` explicitly to make this more obvious.

### Exceptions:

If you're using it correctly and don't mind the potential for confusion, you can save a single character by ignoring this warning.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2253)

