
The `switch` statement should be used only to clearly define some new branches in the control flow. As soon as a `case`<br>clause contains too many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the<br>`case` clause should be extracted into a dedicated method.

## Noncompliant Code Example

With the default threshold of 3:


    switch (myVariable)
    {
        case 0: // Noncompliant: 5 statements in the case
            methodCall1("");
            methodCall2("");
            methodCall3("");
            methodCall4("");
            break;
        case 1:
            ...
    }


## Compliant Solution


    switch (myVariable)
    {
        case 0:
            DoSomething()
            break;
        case 1:
            ...
    }
    ...
    private void DoSomething()
    {
        methodCall1("");
        methodCall2("");
        methodCall3("");
        methodCall4("");
    }

