
Returning `null` instead of an actual array or collection forces callers of the method to explicitly test for nullity, making them more<br>complex and less readable.

Moreover, in many cases, `null` is used as a synonym for empty.

## Noncompliant Code Example


    public Result[] GetResults()
    {
        return null; // Noncompliant
    }
    
    public IEnumerable&lt;Result&gt; GetResults()
    {
        return null; // Noncompliant
    }
    
    public IEnumerable&lt;Result&gt; GetResults() =&gt; null; // Noncompliant
    
    public IEnumerable&lt;Result&gt; Results
    {
        get
        {
            return null; // Noncompliant
        }
    }
    
    public IEnumerable&lt;Result&gt; Results =&gt; null; // Noncompliant


## Compliant Solution


    public Result[] GetResults()
    {
        return new Result[0];
    }
    
    public IEnumerable&lt;Result&gt; GetResults()
    {
        return Enumerable.Empty&lt;Result&gt;();
    }
    
    public IEnumerable&lt;Result&gt; GetResults() =&gt; Enumerable.Empty&lt;Result&gt;();
    
    public IEnumerable&lt;Result&gt; Results
    {
        get
        {
            return Enumerable.Empty&lt;Result&gt;();
        }
    }
    
    public IEnumerable&lt;Result&gt; Results =&gt; Enumerable.Empty&lt;Result&gt;();


## Exceptions

Although `string` is a collection, the rule won't report on it.

## See

- [CERT, MSC19-C.](https://www.securecoding.cert.org/confluence/x/AgG7AQ) - For functions that return an array, prefer returning an<br>  empty array over a null value
- [CERT, MET55-J.](https://www.securecoding.cert.org/confluence/x/zwHEAw) - Return an empty array or collection instead of a null<br>  value for methods that return an array or collection

