
Unused parameters are misleading. Whatever the values passed to such parameters, the behavior will be the same.

This rule raises an issue when a `private` method of a class/struct takes a parameter without using it.

## Noncompliant Code Example


    private void DoSomething(int a, int b) // "b" is unused
    {
        Compute(a);
    }
    
    private void DoSomething2(int a) // value of "a" is unused
    {
        a = 10;
        Compute(a);
    }


## Compliant Solution


    private void DoSomething(int a)
    {
        Compute(a);
    }
    
    private void DoSomething2()
    {
        var a = 10;
        Compute(a);
    }


## Exceptions

This rule doesn't raise any issue in the following contexts:

- The `this` parameter of extension methods.
- Methods decorated with attributes.
- Empty methods.
- Methods which only throw `NotImplementedException`.
- Main methods.
- `virtual`, `override` methods.
- interface implementations.


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

