
For better readability, do not put more than one statement on a single line.

## Noncompliant Code Example


    if(someCondition) DoSomething();


## Compliant Solution


    if(someCondition)
    {
      DoSomething();
    }


## Exceptions

Anonymous functions containing a single statement are ignored. Block statements are not considered either.


    Func&lt;object, bool&gt; item1 = o =&gt; { return true; }; // Compliant
    Func&lt;object, bool&gt; item1 = o =&gt; { var r = false; return r; }; // Noncompliant

