
While it is technically correct to assign to parameters from within method bodies, doing so before the parameter value is read is likely a bug.<br>Instead, initial values of parameters, caught exceptions, and foreach parameters should be, if not treated as `final`, then at least read<br>before reassignment.

## Noncompliant Code Example


    public void DoTheThing(string str, int i, List&lt;string&gt; strings)
    {
      str = i.ToString(i);  // Noncompliant
    
      foreach (var s in strings)
      {
        s = "hello world";  // Noncompliant
      }
    }

