
When the modulus of a negative number is calculated, the result will either be negative or zero. Thus, comparing the modulus of a variable for<br>equality with a positive number (or a negative one) could result in unexpected results.

## Noncompliant Code Example


    public bool IsOdd(int x)
    {
      return x % 2 == 1;  // Noncompliant; if x is an odd negative, x % 2 == -1
    }


## Compliant Solution


    public bool IsOdd(int x)
    {
      return x %2 != 0;
    }


or


    public bool IsOdd(uint x)
    {
      return x %2 == 1;
    }


## See

- [CERT, NUM51-J.](https://www.securecoding.cert.org/confluence/x/xAHAAQ) - Do not assume that the remainder operator always returns a<br>  nonnegative result for integral operands
- [CERT, INT10-C](https://www.securecoding.cert.org/confluence/x/NQBi) - Do not assume a positive remainder when using the % operator<br>

