
`readonly` fields can only be assigned in a class constructor. If a class has a field that's not marked `readonly` but is<br>only set in the constructor, it could cause confusion about the field's intended use. To avoid confusion, such fields should be marked<br>`readonly` to make their intended use explicit, and to prevent future maintainers from inadvertently changing their use.

## Noncompliant Code Example


    public class Person
    {
        private int _birthYear;  // Noncompliant
    
        Person(int birthYear)
        {
            _birthYear = birthYear;
        }
    }


## Compliant Solution


    public class Person
    {
        private readonly int _birthYear;
    
        Person(int birthYear)
        {
            _birthYear = birthYear;
        }
    }


## Exceptions

\* Fields with attributes are ignored.

\* Fields of type `struct` that are not primitive or pointer types are also ignored because of possible unwanted behavior.

## See

\* [Mutating readonly structs](https://ericlippert.com/2008/05/14/mutating-readonly-structs/)
