
Caller information attributes (`CallerFilePathAttribute`, `CallerLineNumberAttribute`, and<br>`CallerMemberNameAttribute`) provide a way to get information about the caller of a method through optional parameters. But they only work<br>right if their values aren't provided explicitly. So if you define a method with caller info attributes in the middle of the parameter list, you put<br>your callers in a bad position: they are forced to use named arguments if they want to use the method properly.

## Noncompliant Code Example


    void TraceMessage([CallerMemberName] string memberName = "",
      [CallerFilePath] string filePath = "",
      [CallerLineNumber] int lineNumber = 0,
      string message = null)  // Noncompliant
    {
      /* ... */
    }


## Compliant Solution


    void TraceMessage(string message = null,
      [CallerMemberName] string memberName = "",
      [CallerFilePath] string filePath = "",
      [CallerLineNumber] int lineNumber = 0)
    {
      /* ... */
    }

