
Generally, writing the least code that will *readably* do the job is a good thing, so omitting default parameter values seems to make sense.<br>Unfortunately, when you omit them from the `base` call in an override, you're not actually getting the job done thoroughly, because you're<br>ignoring the value the caller passed in. The result will likely not be what the caller expected.

## Noncompliant Code Example


    public class BaseClass
    {
        public virtual void MyMethod(int i = 1)
        {
            Console.WriteLine(i);
        }
    }
    
    public class DerivedClass : BaseClass
    {
        public override void MyMethod(int i = 1)
        {
            // ...
            base.MyMethod(); // Noncompliant; caller's value is ignored
        }
    
        static int Main(string[] args)
        {
            DerivedClass dc = new DerivedClass();
            dc.MyMethod(12);  // prints 1
        }
    }


## Compliant Solution


    public class BaseClass
    {
        public virtual void MyMethod(int i = 1)
        {
            Console.WriteLine(i);
        }
    }
    
    public class DerivedClass : BaseClass
    {
        public override void MyMethod(int i = 1)
        {
            // ...
            base.MyMethod(i);
        }
    
        static int Main(string[] args)
        {
            DerivedClass dc = new DerivedClass();
            dc.MyMethod(12);  // prints 12
        }
    }

