
Marking a method with the `Pure` attribute specifies that the method doesn't make any visible changes; thus, the method should return a<br>result, otherwise the call to the method should be equal to no-operation. So `Pure` on a `void` method is either a mistake, or<br>the method doesn't do any meaningful task.

## Noncompliant Code Example


    class Person
    {
      private int age;
      [Pure] // Noncompliant. In this case the method makes a possibly visible state change
      void ConfigureAge(int age)
      {
        ...
        this.age = age;
      }
      ...
    }


## Compliant Solution


    class Person
    {
      private int age;
    
      void ConfigureAge(int age)
      {
        ...
        this.age = age;
      }
      ...
    }

