
If you're using a `struct`, it is likely because you're interested in performance. But by failing to implement<br>`IEquatable<T>` you're loosing performance when comparisons are made because without `IEquatable<T>`, boxing and<br>reflection are used to make comparisons.

## Noncompliant Code Example


    struct MyStruct  // Noncompliant
    {
      private int i;
      public int I
      {
        //...
      }
    }


## Compliant Solution


    struct MyStruct : IEquatable&lt;MyStruct&gt;
    {
      private int i;
      public int I
      {
        //...
      }
    
      public bool Equals(MyStruct other)
      {
        throw new NotImplementedException();
      }
    }

